<?php

namespace Gravity_Forms\Gravity_Forms_Square\API;

defined( 'ABSPATH' ) || die();

use Gravity_Forms\Gravity_Forms_Square\API\Abstracts\Hydration;
use Gravity_Forms\Gravity_Forms_Square\API\Address;

/**
 * Gravity Forms Square Customer Card Object.
 *
 * @see https://developer.squareup.com/reference/square/customers-api/create-customer-card
 *
 * @since     1.3
 * @package   Gravity_Forms
 * @author    Rocketgenius
 * @copyright Copyright (c) 2021, Rocketgenius
 */
class Customer_Card extends Hydration {

	/**
	 * A card nonce representing the credit card to link to the customer.
	 *
	 * Card nonces are generated by the Square Payment Form when customers enter their card information.
	 *
	 * @see https://developer.squareup.com/docs/payment-form/payment-form-walkthrough
	 *
	 * @since 1.3
	 *
	 * @var string Required.
	 */
	public $card_nonce;

	/**
	 * Address information for the card on file. Only the postal_code field is required for payments in the US and Canada.
	 *
	 * @since 1.3
	 *
	 * @var Address
	 */
	public $billing_address;

	/**
	 * The full name printed on the credit card.
	 *
	 * @since 1.3
	 *
	 * @var string
	 */
	public $cardholder_name;

	/**
	 * An identifying token generated by SqPaymentForm.verifyBuyer(). Verification tokens encapsulate customer device information and 3-D Secure challenge results to indicate that Square has verified the buyer identity.
	 *
	 * @since 1.3
	 *
	 * @var string
	 */
	public $verification_token;

	/**
	 * Set the Billing Address property.
	 *
	 * @since 1.3
	 *
	 * @param array|Address $billing_address
	 */
	public function set_billing_address( $billing_address ) {
		if ( ! $billing_address instanceof Address ) {
			$billing_address = new Address( $billing_address );
		}
		$this->billing_address = $billing_address;
	}

}
