/**
 * Init the tec.ticket_plus.waitlistTable object.
 */

tec.tickets_plus = tec.tickets_plus || {};

tec.tickets_plus.waitlistTable = tec.tickets_plus.waitlistTable || {};

(function($, obj){
	const $document = $(document);

	/**
	 * Selectors used to attach listeners.
	 *
	 * @since 6.2.0
	 * @type {Object}
	 */
	obj.selectors = {
		deleteSubscriber: '#the-list .submitdelete',
	};

	/**
	 * I18n strings.
	 *
	 * @since 6.2.0
	 * @type {Object}
	 */
	obj.i18n = {
		confirmDelete: wp.i18n.__( 'Are you sure you want to delete this subscriber?', 'event-tickets-plus' ),
	};

	/**
	 * Delete a subscriber.
	 *
	 * @since 6.2.0
	 * @param {Event} e
	 * @return {void}
	 */
	obj.deleteSubscriber = (e) => {
		e.preventDefault();

		if ( ! confirm( obj.i18n.confirmDelete ) ) {
			return;
		}

		const href = $(e.target).attr('href');

		if ( ! href ) {
			return;
		}

		window.location.href = href;
	};

	/**
	 * Ready function.
	 *
	 * @since 6.2.0
	 * @type {Function}
	 */
	obj.ready = () => {
		$document.on('click', obj.selectors.deleteSubscriber, obj.deleteSubscriber);
	};

	$( obj.ready );
})(jQuery, tec.tickets_plus.waitlistTable)
