import { localizedData } from './constants';

// Initialize from the localized object.
const DEFAULT_STATE = {
	...localizedData,
};

export function reducer(state = DEFAULT_STATE, action) {
	const { ticketsOnSale, ticketsHaveNotStartedSales, ticketsHaveEndedSales } = state.ticketData;
	const {
		ticketsOnSale: rsvpOnSale,
		ticketsHaveNotStartedSales: rsvpHaveNotStartedSales,
		ticketsHaveEndedSales: rsvpHaveEndedSales
	} = state.rsvpData;

	const { availability } = state;

	switch (action.type) {
		case 'SET_USING_ASSIGNED_SEATING':
			return {
				...state,
				isUsingAssignedSeating: !!action.usingAssignedSeating,
			};
		case 'WAITLIST_STATUS_CHANGED':
			return {
				...state,
				waitlistData: {
					...state.waitlistData,
					[action.blockType]: {
						...state.waitlistData[action.blockType],
						enabled: !!action.enabled,
					}
				},
			};
		case 'WAITLIST_CONDITIONAL_CHANGED':
			return {
				...state,
				waitlistData: {
					...state.waitlistData,
					[action.blockType]: {
						...state.waitlistData[action.blockType],
						conditional: action.conditional,
					}
				},
			};
		case 'TICKET_CHANGED':
			const newTicketsOnSale = action.isOnSale ?
				[...ticketsOnSale, action.ticketId] :
				ticketsOnSale.filter((id) => id !== action.ticketId);

			const newticketsHaveNotStartedSales = action.saleHasNotStarted ?
				[...ticketsHaveNotStartedSales, action.ticketId] :
				ticketsHaveNotStartedSales.filter((id) => id !== action.ticketId);

			const newTicketsHaveEndedSales = action.saleHasEnded ?
				[...ticketsHaveEndedSales, action.ticketId] :
				ticketsHaveEndedSales.filter((id) => id !== action.ticketId);

			const ticketsAvailability = availability.tickets[action.ticketId] || { available: action.capacity, sold: 0 };

			ticketsAvailability.available = action.capacity;
			if ( action.capacity !== -1 && ticketsAvailability.sold >= action.capacity ) {
				delete availability.tickets[action.ticketId];

				return {
					...state,
					ticketData: {
						...state.ticketData,
						count: state.ticketData.count + (action.isCreate ? 1 : 0),
						ticketsOnSale: newTicketsOnSale,
						ticketsHaveNotStartedSales: newticketsHaveNotStartedSales,
						ticketsHaveEndedSales: newTicketsHaveEndedSales,
					},
					availability,
				};
			}

			return {
				...state,
				ticketData: {
					...state.ticketData,
					count: state.ticketData.count + (action.isCreate ? 1 : 0),
					ticketsOnSale: newTicketsOnSale,
					ticketsHaveNotStartedSales: newticketsHaveNotStartedSales,
					ticketsHaveEndedSales: newTicketsHaveEndedSales,
				},
				availability: {
					...state.availability,
					tickets: {
						...state.availability.tickets,
						[action.ticketId]: ticketsAvailability,
					},
				},
			};
		case 'TICKET_DELETED':
			delete availability.tickets[action.ticketId];
			return {
				...state,
				ticketData: {
					...state.ticketData,
					count: state.ticketData.count - 1,
					ticketsOnSale: ticketsOnSale.filter((id) => id !== action.ticketId),
					ticketsHaveNotStartedSales: ticketsHaveNotStartedSales.filter((id) => id !== action.ticketId),
					ticketsHaveEndedSales: ticketsHaveEndedSales.filter((id) => id !== action.ticketId),
				},
				availability: availability,
			};
		case 'RSVP_DELETED':
			delete availability.rsvp[action.ticketId];
			return {
				...state,
				rsvpData: {
					...state.rsvpData,
					count: state.rsvpData.count - 1,
					ticketsOnSale: rsvpOnSale.filter((id) => id !== action.ticketId),
					ticketsHaveNotStartedSales: rsvpHaveNotStartedSales.filter((id) => id !== action.ticketId),
					ticketsHaveEndedSales: rsvpHaveEndedSales.filter((id) => id !== action.ticketId),
				},
				availability: availability,
			};
		case 'RSVP_CHANGED':
			const newRSVPOnSale = action.isOnSale ?
				[...rsvpOnSale, action.ticketId] :
				rsvpOnSale.filter((id) => id !== action.ticketId);

			const newRSVPHaveNotStartedSales = action.saleHasNotStarted ?
				[...rsvpHaveNotStartedSales, action.ticketId] :
				rsvpHaveNotStartedSales.filter((id) => id !== action.ticketId);

			const newRSVPHaveEndedSales = action.saleHasEnded ?
				[...rsvpHaveEndedSales, action.ticketId] :
				rsvpHaveEndedSales.filter((id) => id !== action.ticketId);

			const rsvpAvailability = availability.rsvp[action.ticketId] || { available: action.capacity, sold: 0 };

			rsvpAvailability.available = action.capacity;
			if ( action.capacity !== -1 && rsvpAvailability.sold >= action.capacity ) {
				delete availability.rsvp[action.ticketId];

				return {
					...state,
					rsvpData: {
						...state.rsvpData,
						count: state.rsvpData.count + (action.isCreate ? 1 : 0),
						ticketsOnSale: newRSVPOnSale,
						ticketsHaveNotStartedSales: newRSVPHaveNotStartedSales,
						ticketsHaveEndedSales: newRSVPHaveEndedSales,
					},
					availability,
				};
			}

			return {
				...state,
				rsvpData: {
					...state.rsvpData,
					count: state.rsvpData.count + (action.isCreate ? 1 : 0),
					ticketsOnSale: newRSVPOnSale,
					ticketsHaveNotStartedSales: newRSVPHaveNotStartedSales,
					ticketsHaveEndedSales: newRSVPHaveEndedSales,
				},
				availability: {
					...state.availability,
					rsvp: {
						...state.availability.rsvp,
						[action.ticketId]: rsvpAvailability,
					},
				},
			};
	}

	return state;
}
