export const storeName = 'tec-tickets-plus.waitlist';

/**
 * @typedef {'always'|'before-sale'|'on-sold-out'} ConditionalString
 */

/**
 * @typedef { 0 | 1 } TypeInt
 */

/**
 * @typedef {Object} KeysMap
 * @property {string} enabled     Whether the waitlist is enabled.
 * @property {string} conditional The conditional for which the waitlist is enabled.
 */

/**
 * @typedef {Object} ConditionalsMap
 * @property {string} always      The "always" conditional.
 * @property {string} before_sale The "before sale" conditional.
 * @property {string} on_sold_out The "on sold out" conditional.
 */

/**
 * @typedef {Object} WaitlistData
 * @property {Waitlist} tickets The tickets waitlist object.
 * @property {Waitlist} rsvp    The RSVP waitlist object.
 */

/**
 * @typedef {Object} AvailabilityMap
 * @property {Availability} tickets The tickets availability object.
 * @property {Availability} rsvp    The RSVP availability object.
 */

/**
 * @typedef {Object} Availability
 * @property {Available} ticketId The availability of the ticket.
 */

/**
 * @typedef {Object} Available
 * @property {int} available The number of tickets available.
 * @property {int} sold      The number of tickets sold.
 */

/**
 * @typedef {Object} Waitlist
 * @property {int}               waitlist_id The waitlist ID.
 * @property {int}               post_id     The post ID.
 * @property {bool}              enabled     Whether the waitlist is enabled.
 * @property {ConditionalString} conditional The conditional for which the waitlist is enabled.
 * @property {TypeInt}           type        The type of waitlist.
 */

/**
 * @typedef {Object} TicketData
 * @property {int}   count                      The number of tickets
 * @property {int[]} ticketsOnSale              Tickets that are on sale.
 * @property {int[]} ticketsHaveNotStartedSales Tickets that have not started sales.
 * @property {int[]} ticketsHaveEndedSales      Tickets that have ended sales.
 */

/**
 * @typedef {Object} WaitlistStoreLocalizedData
 * @property {TicketData}      ticketData             The ticket data.
 * @property {TicketData}      rsvpData               The RSVP data.
 * @property {AvailabilityMap} availability           The availability of the tickets.
 * @property {WaitlistData}    waitlistData           The waitlist data.
 * @property {bool}            isUsingAssignedSeating Whether the event is using assigned seating.
 * @property {LocalizedData}   localized              The localized data.
 */
export const localizedData = window?.tec?.tickets_plus?.waitlist.blockEditor;

/**
 * @typedef {Object} LocalizedData
 * @property {string}         tableUrl    The table's subscribers URL.
 * @property {SubscribersMap} subscribers The subscribers.
 * @property {MetaKeysObject} metaKeys    The meta keys.
 */

/**
 * @typedef {Object} SubscribersMap
 * @property {int} tickets The amount of tickets subscribers.
 * @property {int} rsvp    The amount of RSVP subscribers.
 */

/**
 * @typedef {Object} MetaKeysObject
 * @property {KeysMap}         tickets      The meta keys for tickets.
 * @property {KeysMap}         rsvp         The meta keys for RSVP.
 * @property {ConditionalsMap} conditionals The conditionals.
 */

export const { metaKeys } = localizedData.localized;
export const { subscribers } = localizedData.localized;
export const { tableUrl } = localizedData.localized;
