import { addFilter, addAction } from '@wordpress/hooks';
import {
	injectWaitlistControlsInTickets,
	injectWaitlistControlsInRSVP,
	updateStoreWithTicket,
	updateStoresTicket,
	updateStoreWithoutTicket,
	updateStoresRSVP,
	updateStoreWithoutRSVP,
	updateStoreWithASCStatus,
	injectWaitlistIsActiveNoticeForTickets,
	injectWaitlistIsActiveNoticeForRSVP
} from './hook-callbacks';

addFilter(
	'tec.tickets.blocks.Tickets.Controls',
	'tec.tickets-plus.waitlist',
	injectWaitlistControlsInTickets
);

addFilter(
	'tec.tickets.blocks.RSVP.Controls',
	'tec.tickets-plus.waitlist',
	injectWaitlistControlsInRSVP
);

addAction(
	'tec.tickets.blocks.rsvp.createdOrUpdated',
	'tec.tickets-plus.waitlist',
	updateStoresRSVP
);
addAction(
	'tec.tickets.blocks.rsvp.deleted',
	'tec.tickets-plus.waitlist',
	updateStoreWithoutRSVP
);

addAction(
	'tec.tickets.blocks.ticketUpdated',
	'tec.tickets-plus.waitlist',
	updateStoresTicket
);

addAction(
	'tec.tickets.blocks.ticketCreated',
	'tec.tickets-plus.waitlist',
	updateStoreWithTicket
);

addAction(
	'tec.tickets.blocks.ticketDeleted',
	'tec.tickets-plus.waitlist',
	updateStoreWithoutTicket
);

addAction(
	'tec.tickets.seating.setUsingAssignedSeating',
	'tec.tickets-plus.waitlist',
	updateStoreWithASCStatus
);

addFilter(
	'tec.tickets.blocks.Tickets.ComponentsBeforeHeader',
	'tec.tickets-plus.waitlist',
	injectWaitlistIsActiveNoticeForTickets
);

addFilter(
	'tec.tickets.blocks.Tickets.ComponentsBeforeInactiveHeader',
	'tec.tickets-plus.waitlist',
	injectWaitlistIsActiveNoticeForTickets
);

addFilter(
	'tec.tickets.blocks.RSVP.ComponentsBeforeHeader',
	'tec.tickets-plus.waitlist',
	injectWaitlistIsActiveNoticeForRSVP
);
