import {addFilter} from '@wordpress/hooks';
import {checkout as checkoutWithTicketsCommerceARModal} from './tc-ar-modal-checkout';
import {checkout as checkoutWithTicketsCommerceARPage} from './tc-ar-page-checkout';
import {checkout as checkoutWithWooCommerce} from "./woo/checkout";
import {localizedData} from './localized-data';

const {isUsingModal} = localizedData;

/**
 * Filters the checkout handler to either show the AR/IAC modal, or rediredt the user to the Attendee
 * Registration page.
 *
 * @since 6.1.0
 *
 * @param {Function|null} checkoutHandler The checkout handler for the provider, `null` if not found.
 * @param {string}        provider        The provider to get the checkout handler for.
 */
function filterCheckoutHandler(checkoutHandler, provider) {
	switch (provider) {
		case 'TECTicketsCommerceModule':
		case 'TEC\\Tickets\\Commerce\\Module':
			return isUsingModal ?
				checkoutWithTicketsCommerceARModal
				: checkoutWithTicketsCommerceARPage;
		case 'Tribe__Tickets_Plus__Commerce__WooCommerce__Main':
			return isUsingModal ?
				checkoutWithTicketsCommerceARModal
				: checkoutWithWooCommerce;
		default:
			return null;
	}
}

addFilter('tec.tickets.seating.checkoutHandler', 'tec-tickets-plus-seating', filterCheckoutHandler);

