import { setIsInterruptable } from "@tec/tickets/seating/frontend/session";

/**
 * Prevents the session from being interrupted when the user is redirected from the AR page to the checkout page.
 *
 * @since 6.1.0
 *
 * @param {HTMLElement|null} dom The DOM element to use as the base for the search.
 */
export function doNotInterruptLeavingToModifyAttendees(dom) {
	dom = dom || document;

	const targets = [
		'.tribe-tickets__commerce-checkout-header-link-modify-attendees',
		'.tribe-checkout-backlink',
		'a',
	];

	dom.querySelectorAll( targets.join( ', ' ) ).forEach( el => {
		el.addEventListener( 'click', () => setIsInterruptable( false ) );
	} );

	// Find woo checkout form.
	const wooCheckoutForm = dom.querySelector( '.woocommerce-checkout' );

	if ( wooCheckoutForm ) {
		setIsInterruptable( false );
		return;
	}

	// Find woo cart form.
	const wooCartForm = dom.querySelector( '.woocommerce-cart-form' );

	if ( wooCartForm ) {
		setIsInterruptable( false );
		return;
	}

	// Find woo cart block.
	const wooCartBlock = dom.querySelector( '.wc-block-cart__main' );

	if ( wooCartBlock ) {
		setIsInterruptable( false );
		return;
	}

	// Find AR page.
	const arPage = dom.querySelector( '.tribe-tickets__attendee-tickets' );

	if ( arPage ) {
		setIsInterruptable( false );
	}
}
