import { onReady } from "@tec/tickets/seating/utils";
import { doNotInterruptLeavingToModifyAttendees } from "./modify-attendees";
import { addFilter } from '@wordpress/hooks';

onReady(() => doNotInterruptLeavingToModifyAttendees());

/**
 * Filters the checkout controls to include the payment button.
 *
 * @since 6.3.0
 *
 * @param {string[]} selectors The selectors to filter.
 *
 * @return {string[]} The filtered selectors.
 */
const filterCheckoutControls = (selectors) => {
	selectors.push( '.woocommerce-checkout-payment button' );
	return selectors;
};

addFilter( 'tec.tickets.seating.frontend.session.checkoutControls', 'tec-tickets-plus-seating', filterCheckoutControls );
