/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "bzn6");
/******/ })
/************************************************************************/
/******/ ({

/***/ "KO+N":
/***/ (function(module, exports) {

module.exports = tec.tickets.seating.frontend.session;

/***/ }),

/***/ "MsaN":
/***/ (function(module, exports) {

module.exports = tec.tickets.seating.utils;

/***/ }),

/***/ "bzn6":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: external "tec.tickets.seating.utils"
var external_tec_tickets_seating_utils_ = __webpack_require__("MsaN");

// EXTERNAL MODULE: external "tec.tickets.seating.frontend.session"
var external_tec_tickets_seating_frontend_session_ = __webpack_require__("KO+N");

// CONCATENATED MODULE: ./src/Tickets_Plus/Seating/app/frontend/checkout/modify-attendees.js


/**
 * Prevents the session from being interrupted when the user is redirected from the AR page to the checkout page.
 *
 * @since 6.1.0
 *
 * @param {HTMLElement|null} dom The DOM element to use as the base for the search.
 */
function doNotInterruptLeavingToModifyAttendees(dom) {
  dom = dom || document;
  const targets = ['.tribe-tickets__commerce-checkout-header-link-modify-attendees', '.tribe-checkout-backlink', 'a'];
  dom.querySelectorAll(targets.join(', ')).forEach(el => {
    el.addEventListener('click', () => Object(external_tec_tickets_seating_frontend_session_["setIsInterruptable"])(false));
  });

  // Find woo checkout form.
  const wooCheckoutForm = dom.querySelector('.woocommerce-checkout');
  if (wooCheckoutForm) {
    Object(external_tec_tickets_seating_frontend_session_["setIsInterruptable"])(false);
    return;
  }

  // Find woo cart form.
  const wooCartForm = dom.querySelector('.woocommerce-cart-form');
  if (wooCartForm) {
    Object(external_tec_tickets_seating_frontend_session_["setIsInterruptable"])(false);
    return;
  }

  // Find woo cart block.
  const wooCartBlock = dom.querySelector('.wc-block-cart__main');
  if (wooCartBlock) {
    Object(external_tec_tickets_seating_frontend_session_["setIsInterruptable"])(false);
    return;
  }

  // Find AR page.
  const arPage = dom.querySelector('.tribe-tickets__attendee-tickets');
  if (arPage) {
    Object(external_tec_tickets_seating_frontend_session_["setIsInterruptable"])(false);
  }
}
// EXTERNAL MODULE: external "wp.hooks"
var external_wp_hooks_ = __webpack_require__("g56x");

// CONCATENATED MODULE: ./src/Tickets_Plus/Seating/app/frontend/checkout/index.js



Object(external_tec_tickets_seating_utils_["onReady"])(() => doNotInterruptLeavingToModifyAttendees());

/**
 * Filters the checkout controls to include the payment button.
 *
 * @since 6.3.0
 *
 * @param {string[]} selectors The selectors to filter.
 *
 * @return {string[]} The filtered selectors.
 */
const filterCheckoutControls = selectors => {
  selectors.push('.woocommerce-checkout-payment button');
  return selectors;
};
Object(external_wp_hooks_["addFilter"])('tec.tickets.seating.frontend.session.checkoutControls', 'tec-tickets-plus-seating', filterCheckoutControls);

/***/ }),

/***/ "g56x":
/***/ (function(module, exports) {

module.exports = wp.hooks;

/***/ })

/******/ });