<?php
function email_logo() {

    // We have a logo. Logo is go.
    if ( has_custom_logo() ) {
        $custom_logo_id   = get_theme_mod( 'custom_logo' );
        $custom_logo_attr = array(
            'class'   => 'custom-logo',
            'loading' => false,
            'style' => 'width:100%; height:auto',
            'alt' => get_bloginfo( 'name', 'display' )
        );

        $image = wp_get_attachment_image( $custom_logo_id, 'full', false, $custom_logo_attr);
    }

    return $image ?: 'Set a Featured Image';
}

?>
<script src="https://unpkg.com/vue@3/dist/vue.global.js"></script>
<style>

    #app {
        background:white;
        padding:40px;
    }

    #app label span {
        display:block;
    }

    #app h3 {
        border-bottom:1px solid #000
    }

    #left-area {
        float:none;
        width:auto;
    }

    #instructions {
        margin:20px 0;
        background:#EEE;
        padding:20px;
    }

    #instructions .inner {
        display:grid;
        grid-template-columns: 1fr 2fr;
        grid-gap:20px;
    }

    #instructions ol {
        font-size:14px;
    }

    #app .info {
        display:grid;
        grid-template-columns:1fr 1fr;
    }

</style>
<div id="app">

    <h3>Data</h3>

    <div class="info">
        <div class="data">
            <label><span>Name</span><input type="text" v-model="name" /></label>
            <label><span>Title</span><input type="text" v-model="title" /></label>
            <label><span>Email</span><input type="text" v-model="email" /></label>
            <label><span>Phone</span><input type="text" v-model="phone" /></label>
            <label><span>Mobile</span><input type="text" v-model="mobile" /></label>
            <label><span>Fax</span><input type="text" v-model="fax" /></label>
            <label><span>Website</span><input type="text" v-model="website" /></label>
        </div>
        <div class="presentation">
            <label><span>Width</span><input type="number" v-model="width" /></label>
            <label><span>Primary Color</span><input type="color" v-model="color_primary" /></label>
            <label><span>Accent Color</span><input type="color" v-model="color_accent" /></label>
        </div>
    </div>

    <p>&nbsp;</p>
    <h3>Sample</h3>
    <p>&nbsp;</p>

    <button onclick="selectText('signature'); document.execCommand('copy'); alert('Code Copied!')">Copy</button>
    <br />
    <br />
    <div id="signature">
        <table style="border-spacing:0; border:0;">
            <tr>
                <td :style="{ paddingRight:'30px', border:'0', borderRight:'2px solid ' + color_accent, width: width + 'px' }">
                    <a :href="website" style="display:block"><?= email_logo() ?></a>
                </td>
                <td :style="{ paddingLeft:'30px', fontFamily: '\'Open Sans\', Arial, sans-serif', fontSize:'14px', color: color_primary, lineHeight: 1.3,  border:0 }">
                    <div style="margin-bottom:10px;">
                        <div><strong :style="{ color:color_primary, whiteSpace:'nowrap' }">{{ name }}</strong></div>
                        <em style="display:block; white-space:nowrap" v-if="title">{{ title }}</em>
                    </div>
                    <div style="margin-bottom:10px;">
                        <div style="white-space:nowrap" v-if="email">email: <a :href="'mailto:' + email" :style="{ color: color_accent }">{{ email }}</a></div>
                        <div style="white-space:nowrap" v-if="phone">phone: <a :href="'tel:' + phone" :style="{ color: color_accent }">{{ phone }}</a></div>
                        <div style="white-space:nowrap" v-if="mobile">mobile: <a :href="'tel:' + mobile" :style="{ color: color_accent }">{{ mobile }}</a></div>
                        <div style="white-space:nowrap" v-if="fax">fax: <a :href="'tel:' + fax" :style="{ color: color_accent }">{{ fax }}</a></div>
                    </div>
                    <div><a :href="website" :style="{ color: color_accent }">{{ website }}</a></div>
                </td>
            </tr>
        </table>
    </div>

    <p>&nbsp;</p>

    <h3>Instructions</h3>

    <div id="instructions">

        <div class="inner">
            <ol>
                <li>Fill Out Form</li>
                <li>Click Generate</li>
                <li>Click Copy Near The Preview</li>
                <li>Open Outlook</li>
                <li>Open Settings (Gear in Upper Right)</li>
                <li>Select Compose and Reply Under Mail</li>
                <li>Name Your Signature</li>
                <li>Paste (CTRL+V) or Right Click and Paste</li>
                <li>Click Save</li>
                <li>Select Your New Signature under Default Signatures</li>
                <li>Click Save</li>
                <li>Close Settings and Send Mail!</li>
            </ol>
            <iframe width="100%" height="300" src="https://www.youtube.com/embed/0whC2MJJx6o?si=d6OQsE5Jalk_gZM7" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
        </div>
    </div>
</div>
<script type="text/javascript">

    const { createApp, ref } = Vue

    createApp({
        setup() {
            const name = ref('');
            const title = ref('');
            const email = ref('');
            const phone = ref('');
            const mobile = ref('');
            const fax = ref('');
            const website = ref('<?= home_url() ?>');

            const width = ref(200);
            const color_primary = ref('#222222');
            const color_accent = ref('#1E75BC');

            return {
                name,
                title,
                email,
                phone,
                mobile,
                fax,
                website,
                width,
                color_primary,
                color_accent
            }
        }
    }).mount('#app');


    function selectText(node) {
        node = document.getElementById(node);

        if (document.body.createTextRange) {
            const range = document.body.createTextRange();
            range.moveToElementText(node);
            range.select();
        } else if (window.getSelection) {
            const selection = window.getSelection();
            const range = document.createRange();
            range.selectNodeContents(node);
            selection.removeAllRanges();
            selection.addRange(range);
        } else {
            console.warn("Could not select text in node: Unsupported browser.");
        }
    }
</script>
