<?php
/*
Plugin Name:  Email Signature Generator
Plugin URI:   https://letsgodojo.com
Description:  Creates an option page to generate email signatures
Version:      1.0
Author:       DOJO Creative
Author URI:   https://letsgodojo.com
License:      Private
*/

class Email_Signature_Generator {

    public function __construct()
    {
        add_action( 'admin_menu', array( $this, 'admin_menu' ) );
    }

    public function admin_menu()
    {
        add_options_page(
            'Email Signature Generator',
            'Email Signature',
            'manage_options',
            'email-signature-generator',
            [$this, 'settings_page']
        );
    }


    public function settings_page()
    {
        ob_start();
        include __DIR__.'/template/signature-generator.php';
        $html = ob_get_clean();

        echo $html;
    }
}

new Email_Signature_Generator();
