<?php
/* @var $model array */
?>

<div class="wapf-field__setting" data-setting="<?php echo $model['id']; ?>">

	<div class="wapf-setting__label">
		<label><?php _e($model['label'],'sw-wapf');?></label>
		<?php if(isset($model['description'])) { ?>
			<p class="wapf-description">
				<?php _e($model['description'],'sw-wapf');?>
			</p>
		<?php } ?>
	</div>

	<div class="wapf-setting__input">

		<div class="wapf-toggle" rv-unique-checkbox>
			<input rv-on-change="toggleGalleryImages" rv-checked="settings.enable_gallery_images" type="checkbox" >
			<label class="wapf-toggle__label" for="wapf-toggle-">
				<span class="wapf-toggle__inner" data-true="<?php _e('Yes','sw-wapf'); ?>" data-false="<?php _e('No','sw-wapf'); ?>"></span>
				<span class="wapf-toggle__switch"></span>
			</label>
		</div>

		<div class="wapf-gallery_image_wrapper" rv-show="settings.enable_gallery_images">
            <div class="wapf-gallery_image" rv-cloak rv-each-savedimage="settings.gallery_images" rv-data-index="$index">
                <div class="wapf-gallery_image_close"><a href="#" rv-on-click="deleteGalleryImage" class="wapf-button--tiny-rounded">×</a></div>
                <div class="wapf-gallery_image_drag">☰</div>
                <div class="wapf-gallery_image_item" rv-each-value="savedimage.values">
                    <span class="gallery_image_title" rv-html="value.field | getFieldProperty fields 'label'"></span>
                    <select rv-value="value.value" rv-on-change="onChange">
                        <option value="*" ><?php _e('Any','sw-wapf');?></option>
                        <option rv-each-choice="fields | getChoiceFieldValues value.field" rv-value="choice.value">{ choice.label }</option>
                    </select>
                </div>

                <div>
                    <div ng-show="galleryImages | isNotEmpty">
                        <div style="padding: 8px 0;"><?php _e('Select an image from the product gallery:','sw-wapf'); ?></div>
                        <div rv-on-click="setProductImage" rv-each-image="galleryImages" class="wapf-gallery_img" rv-class-active="savedimage.id | eqloose image.id">
                            <img rv-src="image.url" />
                        </div>
                    </div>
                    <div>
                        <div style="padding:8px 0;" class="wapf-media-selector">
                            <a rv-hide="galleryImages | isNotEmpty" class="wapf-btn-add-media" href="#">
					            <?php _e('Select image', 'sw-wapf'); ?>
                            </a>
                            <a rv-hide="galleryImages | isEmpty" class="wapf-btn-add-media" href="#">
					            <?php _e('Or select other image', 'sw-wapf'); ?>
                            </a>
                            <div rv-productgallery="savedimage" class="wapf-media-preview" rv-class-wapf-hide="savedimage.url | isEmpty" rv-hide="savedimage.source | neq 'upload'">
                                <a class="wapf-btn-add-media"><img rv-src="savedimage.url" /></a>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div style="padding-top:15px;width: 100%;">
                <p>
	                <?php _e('The product image can change on the frontend. You can add rules below. A rule holds a set of values which have to be true before showing that product image. If two or more rules are true, the last rule will be used','sw-wapf'); ?>
                </p>
                <div rv-if="showAddNewRule | eq false">
                    <p>
                        <i><?php _e("You can't add any rules yet. Please add at least one of these fields first: true-false, select, swatches, checkboxes, or radio buttons.",'sw-wapf'); ?></i>
                    </p>
                </div>
                <div rv-if="showAddNewRule">
                    <a href="#" rv-on-click="addGalleryImage" class="button button-small"><?php _e('Add new rule','sw-wapf'); ?></a>
                </div>
            </div>
		</div>

	</div>
</div>