<?php

namespace SW_WAPF_PRO\Includes\Models {

	use SW_WAPF_PRO\Includes\Classes\Enumerable;
	use SW_WAPF_PRO\Includes\Classes\Helper;

	if (!defined('ABSPATH')) {
        die;
    }

    class FieldGroup
    {
        public $id;

        public $type;

        public $rules_groups;

        public $fields;

        public $layout;

        public $variables;

        public function __construct()
        {
            $this->type = 'wapf_product';
            $this->rules_groups = [];
            $this->fields = [];
            $this->variables = [];

            $this->layout = array(
                'labels_position'       => 'above',
                'instructions_position' => 'field',
                'mark_required'         => true,
	            'enable_gallery_images' => false,
	            'gallery_images'        => array()
            );
        }

        public function has_gallery_image_rules() {

        	if(!isset($this->layout['enable_gallery_images']))
        		return false;

        	return $this->layout['enable_gallery_images'] === true && count($this->layout['gallery_images']) > 0;
        }

        public function get_field($id){
        	foreach ($this->fields as $field) {
        		if($field->id === $id)
        			return $field;
	        }
        	return null;
        }

        public function has_variables(){
        	return !empty($this->variables);
        }

        public function get_gallery_image_rules() {

        	$result = array(
        		'images'    => array(),
		        'rules'     => array(),
	        );

        	foreach ($this->layout['gallery_images'] as $gallery_image) {

        		if(empty($gallery_image['id']) || empty($gallery_image['values']))
        			continue;

        		$result['rules'][] = array(
        			'values'    => $gallery_image['values'],
			        'image'     => $gallery_image['id']
		        );

        		if($gallery_image['source'] === 'upload' && !Enumerable::from($result['images'])->any(function($x) use ($gallery_image){ return $x['image_id'] === $gallery_image['id']; }))
        			$result['images'][] = array_merge( wc_get_product_attachment_props($gallery_image['id']), array('image_id' => $gallery_image['id']) );

        	}

        	return $result;

        }
    }
}