<?php

namespace SW_WAPF_PRO\Includes\Models {

    use SW_WAPF_PRO\Includes\Classes\Enumerable;

    if (!defined('ABSPATH')) {
        die;
    }

    class Field
    {

        public $id;

        public $key;

        public $label;

        public $description;

        public $type;

        public $required;

        public $options;

        public $conditionals;

        public $class;

        public $width;

        public $pricing;

        public $tax;

        public $qty_based;
        public $parent_qty_based;
        public $clone_txt;

        public function __construct()
        {
            $this->label = '';
            $this->options = [];
            $this->conditionals = [];
            $this->pricing = new FieldPricing();
            $this->qty_based = false;
            $this->parent_qty_based = false;
        }

        public function get_label(){

        	if(!empty($this->label))
        		return $this->label;

        	if($this->type === 'true-false' && !empty($this->options['message']))
        		return $this->options['message'];

        	return __('N/a','sw-wapf');

        }

        public function get_option($key,$default = null) {
        	if(isset($this->options[$key]))
        		return $this->options[$key];
        	return $default;
        }

        public function is_choice_field(){
            return in_array($this->type, array('select','checkboxes','radio','image-swatch','multi-image-swatch','color-swatch','multi-color-swatch','text-swatch','multi-text-swatch'));
        }

        public function is_content_field() {
        	return in_array($this->type, array('p','img'));
        }

        public function has_conditionals() {
        	return count($this->conditionals) > 0;
        }

        public function is_field_or_parent_qty_based() {
        	return $this->qty_based || $this->parent_qty_based;
        }

        public function pricing_enabled() {

            if($this->is_choice_field() && !empty($this->options['choices']))
                return Enumerable::from($this->options['choices'])->any(function($choice){
                    return isset($choice['pricing_type']) && $choice['pricing_type'] !== 'none';
                });

            return $this->pricing->enabled;

        }

    }
}