<?php

namespace SW_WAPF_PRO\Includes\Controllers {

	use SW_WAPF_PRO\Includes\Classes\Cache;
	use SW_WAPF_PRO\Includes\Classes\Cart;
	use SW_WAPF_PRO\Includes\Classes\Enumerable;
    use SW_WAPF_PRO\Includes\Classes\Field_Groups;
    use SW_WAPF_PRO\Includes\Classes\Fields;
	use SW_WAPF_PRO\Includes\Classes\File_Upload;
	use SW_WAPF_PRO\Includes\Classes\Helper;
	use SW_WAPF_PRO\Includes\Classes\Html;
	use SW_WAPF_PRO\Includes\Models\Field;
	use SW_WAPF_PRO\Includes\Models\FieldGroup;

	if (!defined('ABSPATH')) {
        die;
    }

    class Product_Controller
    {

    	public $show_fieldgroup = false;

        public function __construct()
        {
            add_action('woocommerce_before_add_to_cart_button',             array($this, 'display_field_groups' ));

            add_action('wp_footer',                                         array($this,'remove_image_update_function'), 999999);

            add_filter('woocommerce_add_to_cart_validation',                array($this, 'validate_cart_data'), 10, 4);

	        add_filter('woocommerce_add_cart_item_data',                    array($this, 'add_fields_to_cart_item' ), 10, 4 );

            add_action('woocommerce_add_to_cart',                           array($this, 'split_cart_items_by_quantity'), 10, 6 );

	        add_action('woocommerce_add_to_cart',                           array($this, 'calculate_cart_item_price'), 10, 6 );

	        add_filter('woocommerce_update_cart_action_cart_updated',       array($this, 'recalculate_cart_item_price'));

            add_action('woocommerce_before_calculate_totals',               array($this, 'add_prices_to_cart_item'));

            add_filter('woocommerce_get_item_data',                         array($this, 'display_fields_on_cart_and_checkout'),10, 2);

	        add_filter('woocommerce_cart_item_price',                       array($this, 'mini_cart_display_product_price'),10,3);

            add_action('woocommerce_checkout_create_order_line_item',       array($this, 'create_order_line_item'), 20, 4);

            add_filter('woocommerce_product_add_to_cart_text',              array($this, 'change_add_to_cart_text'), 10, 2);

            add_filter('woocommerce_product_supports',                      array($this, 'check_product_support'), 10, 3);

            add_filter('woocommerce_product_add_to_cart_url',               array($this, 'set_add_to_cart_url'), 10, 2);

			add_filter('woocommerce_single_product_image_thumbnail_html',   array($this,'add_attachment_id_to_html'), 10, 2 );
        }

        public function add_attachment_id_to_html($html, $attachment_id) {
        	return str_replace('<div ','<div data-wapf-att-id="'.$attachment_id.'" ',$html);
        }

        public function set_add_to_cart_url($url, $product) {
            if($product->get_type() === 'external')
                return $url;

            if(Field_Groups::product_has_field_group($product))
                return $product->get_permalink();

            return $url;
        }

        public function check_product_support($support, $feature, $product)
        {
            if($feature === 'ajax_add_to_cart' && Field_Groups::product_has_field_group($product) )
                $support = false;

            return $support;
        }

        public function change_add_to_cart_text($text, $product) {
            if(!$product->is_in_stock())
                return $text;

            if (in_array($product->get_type(), array('grouped', 'external')))
                return $text;

            if( Field_Groups::product_has_field_group($product) )
                return esc_html(get_option('wapf_add_to_cart_text',__('Select options','sw-wapf')));

            return $text;

        }

        public function validate_cart_data($passed, $product_id, $qty, $variation_id = null) {

            if(!isset($_REQUEST['wapf_field_groups']))
                return $passed;

            $field_groups = Field_Groups::get_by_ids(explode(',',sanitize_text_field($_REQUEST['wapf_field_groups'])));

            $files = File_Upload::create_uploaded_file_array();
			Cache::set_files($files); 

	        $file_fields = array(); 

            foreach($field_groups as $group) {
	            foreach($group->fields as $field) {

		            $filter = 'wapf/validate/' . $field->id;
		            if(has_filter($filter)) {
			            $value = Fields::get_raw_field_value_from_request($field, 0, true);
			            $error = apply_filters($filter, array('error' => !$passed), $value, $field, $product_id, 1);
			            if($error['error']) {
				            wc_add_notice(esc_html($error['message']),'error');
				            return false;
			            }

			            if($qty > 1 && $field->is_field_or_parent_qty_based() ) {
				            for($i = $qty; $i >= 2; $i-- ) {
					            $value = Fields::get_raw_field_value_from_request($field,$i,true);
					            $error = apply_filters($filter, array('error' => !$passed), $value, $field, $product_id, $i);

					            if($error['error']) {
						            wc_add_notice(esc_html($error['message']), 'error');
						            return false;
					            }
				            }
			            }

		            }

		            if($field->type === 'file') {
		            	$file_fields[] = $field;
			            if(!File_Upload::validate_files_for_field( $files, $field ))
			            	return false;
			            if($qty > 1 && $field->is_field_or_parent_qty_based() ) {
				            for($i = $qty; $i >= 2; $i-- ) {
					            if(!File_Upload::validate_files_for_field( $files, $field,$i ))
						            return false;
				            }
			            }
		            }

		            if(!Fields::should_field_be_filled_out($group,$field, $variation_id  === null ? $product_id : $variation_id))
	            		continue;

		            $value = Fields::get_raw_field_value_from_request($field, 0, true);

		            if($value === '' || $value === null) {
			            wc_add_notice(__('The field "' . esc_html($field->get_label()) . '" is required.', 'sw-wapf'), 'error');
			            return false;
		            }

		            if($qty > 1 && $field->is_field_or_parent_qty_based() ) {
			            for($i = $qty; $i >= 2; $i-- ) {
				            $value = Fields::get_raw_field_value_from_request($field,$i,true);

				            if($value === '' || $value === null) {
					            wc_add_notice(__('The field "' . esc_html($field->get_label()) . '" is required.', 'sw-wapf'), 'error');
					            return false;
				            }
			            }
		            }

	            }
            }

            if($passed && !empty($files)) {
	            foreach ($files as $key => &$files_arr) {

	            	$key = explode('_',str_replace('field_','',$key))[0];
		            $field = Enumerable::from($file_fields)->firstOrDefault(function($x) use ($key) {return $x->id === $key;});
		            if(!$field)
			            continue;

		            foreach($files_arr as &$file) {
			            if(empty($file['name']) || isset($file['uploaded_file']))
				            continue;

			            $upload = File_Upload::handle_upload($file, $field);
			            if(empty($upload['error'])) {
							$file['uploaded_file'] = $upload['url'];
			            } else {
				            wc_add_notice(
					            sprintf(apply_filters('wapf/message/file_upload_error', __( "Error uploading file \"%s\". %s", 'sw-wapf' )),$file['name'], $upload['error'])
					            , 'error'
				            );
				            return false;
			            }
		            }
	            }
	            Cache::set_files($files);
            }

            return $passed;

        }

        public function preprocessing($field_groups) {

	        foreach($field_groups as $field_group) {
		        foreach ($field_group->fields as $field) {
			        if($field->type === 'text-swatch' || $field->type === 'multi-text-swatch') {
				        Cache::add_css('[for="'.$field->id.'"] .wapf-swatch', array(
					        'border-color' => $field->options['border'],
				        ));
				        Cache::add_css('[for="'.$field->id.'"] .wapf-swatch.wapf-checked', array(
					        'background' => $field->options['selected_bg'],
					        'border-color' => $field->options['selected_bg'],
					        'color'      => $field->options['selected_fg']
				        ));
				        Cache::add_css('[for="'.$field->id.'"] .wapf-swatch:hover', array(
					        'border-color' => $field->options['selected_bg'],
				        ));
				        Cache::add_css('[for="'.$field->id.'"] .wapf-swatch:hover', array(
					        'border-color' => $field->options['selected_bg'],
				        ));
			        }
		        }
	        }

        }

        public function display_field_groups() {

            global $product;
            if(!$product)
                return;

            if(in_array($product->get_type(),array('grouped','external')))
                return;

            $field_groups = Field_Groups::get_valid_field_groups('product');

            $product_field_group = get_post_meta($product->get_id(),'_wapf_fieldgroup', true);

            if($product_field_group)
                array_unshift($field_groups, Field_Groups::process_data($product_field_group));

            if(empty($field_groups))
                return;

            $group_ids = array();

            $this->show_fieldgroup = true;

            do_action('wapf_before_wrapper', $product);

            echo '<div class="wapf-wrapper">';
            foreach ($field_groups as $field_group) {

                $group_ids[] = $field_group->id;

                echo Html::field_group($product,$field_group);

            }

            echo '<input type="hidden" value="'.implode(',',$group_ids).'" name="wapf_field_groups"/>';
            echo '</div>';

            do_action('wapf_before_product_totals', $product);

	        Html::product_totals($product);

	        do_action('wapf_after_product_totals', $product);

        }

        public function remove_image_update_function() {
        	if(!$this->show_fieldgroup)
        		return;

        	echo '<script>jQuery(document).on(\'wapf:delete_var\',function(){if(jQuery.fn.wc_variations_image_update) jQuery.fn.wc_variations_image_update = function(){}; });</script>';
        }

        public function add_fields_to_cart_item($cart_item_data, $product_id, $variation_id, $quantity = 1) {

	        if( isset($cart_item_data['wapf']) || !isset($_REQUEST['wapf_field_groups']))
		        return $cart_item_data;

	        $field_group_ids = explode(',', sanitize_text_field($_REQUEST['wapf_field_groups']));
	        $field_groups = Field_Groups::get_by_ids($field_group_ids);
	        $fields = Enumerable::from($field_groups)->merge(function($x){return $x->fields; })->toArray();


			$files = Cache::get_files();

            $wapf_data = array();
			$clones = array();

            foreach($fields as $field) {
	            $key = 'field_' . $field->id;


            	if( ($field->type === 'file' && isset($files[$key]) ) || (isset($_REQUEST['wapf']) && isset($_REQUEST['wapf'][$key])) ) {
		            $cart_field  = self::to_cart_fields( $field, 0 );
		            $wapf_data[] = $cart_field;
	            }

	            if($quantity > 1) {
	            	for($i=2; $i <= $quantity ; $i++) {
	            		$key = 'field_' . $field->id . '_clone_' . $i;

	            		if( ($field->type === 'file' && isset($files[$key])) || (isset($_REQUEST['wapf']) && isset($_REQUEST['wapf'][$key])) ) {
				            $cart_field = self::to_cart_fields( $field, $i );
				            $clones[ $i - 2 ][] = $cart_field;
			            }
		            }
	            }
            }

	        $sorted = $wapf_data;
	        $sorted = Enumerable::from($sorted)->orderBy(function($x) { return $x['id']; })->toArray();
	        $wapf_unique_key = $this->generate_cart_item_id($product_id,$variation_id,array_values($sorted));

	        if(!empty($clones))
		        Cache::add_clone($wapf_unique_key, $clones);

	        if(!empty($wapf_data)) {
		        $cart_item_data['wapf'] = $wapf_data;
		        $cart_item_data['wapf_key'] = $wapf_unique_key;
		        $cart_item_data['wapf_field_groups'] = $field_group_ids;
		        $cart_item_data['wapf_clone'] = 0;
	        }

	        return $cart_item_data;

        }

	    public function split_cart_items_by_quantity($cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data) {

		    if($quantity === 1) return;

		    if(empty($cart_item_data['wapf']) || !is_array($cart_item_data['wapf']) )
			    return;

		    $cart_data_clones = Cache::get_clone($cart_item_data['wapf_key']);

		    if(!$cart_data_clones || empty($cart_data_clones))
			    return;

		    $fingerprint = $cart_item_data['wapf_key'];

		    $main_item_qty = isset(WC()->cart->cart_contents[$cart_item_key]['quantity']) ? WC()->cart->cart_contents[$cart_item_key]['quantity'] : 1;

		    $field_groups = Field_Groups::get_by_ids($cart_item_data['wapf_field_groups']);
		    $fields = Enumerable::from($field_groups)->merge(function($x){return $x->fields; })->toArray();
		    for($i=0; $i < count($cart_data_clones); $i++) {
			    $clone_group = $cart_data_clones[$i];
			    $complete_clone  = array();

			    foreach ($fields as $field) {
				    $field_in_clone = Enumerable::from($clone_group)->firstOrDefault(function($clone_field) use ($field) {
					    return $field->id === $clone_field['id'];
				    });
				    if($field_in_clone)
					    $complete_clone[] = $field_in_clone;
				    else {
					    $field_in_parent = Enumerable::from($cart_item_data['wapf'])->firstOrDefault(function($parent_field) use($field) {
						    return $field->id === $parent_field['id'];
					    });
					    if($field_in_parent)
						    $complete_clone[] = $field_in_parent;
				    }

			    }

			    $ordered = array_values( Enumerable::from( $complete_clone )->orderBy( function ( $x ) {
				    return $x['id'];
			    } )->toArray() );

			    $clone_fingerprint = $this->generate_cart_item_id( $product_id, $variation_id, $ordered );

			    if ( $clone_fingerprint !== $fingerprint ) {

				    $content = WC()->cart->cart_contents;
				    $is_in_cart = false;
				    foreach ( $content as $key => $item_in_cart ) {
					    if ( empty( $item_in_cart['wapf'] ) || $key === $cart_item_key )
						    continue;

					    $item_fingerprint = $item_in_cart['wapf_key'];

					    if ( $item_fingerprint === $clone_fingerprint ) {
						    $old_qty = empty( $item_in_cart['quantity'] ) ? 1 : $item_in_cart['quantity'];
						    WC()->cart->set_quantity( $key, $old_qty + 1 );
						    $is_in_cart = true;
						    break;
					    }
				    }

				    if ( ! $is_in_cart ) {

					    $new_cart_item_data = array(
						    'wapf'              => $complete_clone,
						    'wapf_key'          => $clone_fingerprint,
						    'wapf_field_groups' => $cart_item_data['wapf_field_groups'],
						    'wapf_clone'        => $i+2,
					    );

					    remove_action('woocommerce_add_to_cart', array($this, 'split_cart_items_by_quantity'));
					    remove_action('woocommerce_add_cart_item_data', array($this, 'add_fields_to_cart_item'));

					    WC()->cart->add_to_cart( $product_id, 1, $variation_id, $variation, $new_cart_item_data );

					    add_action('woocommerce_add_to_cart', array($this, 'split_cart_items_by_quantity'));
					    add_action('woocommerce_add_cart_item_data', array($this, 'add_fields_to_cart_item'));
				    }

				    $main_item_qty = $main_item_qty - 1;
				    if($main_item_qty < 1)
					    $main_item_qty = 1;
				    WC()->cart->set_quantity( $cart_item_key, $main_item_qty );

			    }
		    }

	    }

	    public function calculate_cart_item_price($cart_item_key,$product_id,$quantity,$variation_id,$variation,$cart_item_data) {
	        if(empty($cart_item_data['wapf']))
		        return;

	        $cart_item = WC()->cart->cart_contents[$cart_item_key];

	        $pricing = Cart::calculate_cart_item_options_total($cart_item);

		    if($pricing !== false)
		        WC()->cart->cart_contents[ $cart_item_key ]['wapf_item_price'] = $pricing;

        }

	    public function recalculate_cart_item_price($cart_updated) {

		    if(!$cart_updated)
			    return;

		    $cart = WC()->cart->get_cart();
		    foreach( $cart as $key=>$item ) {
		    	if(!empty($item['wapf'])) {
				    $pricing = Cart::calculate_cart_item_options_total($item);
				    if($pricing !== false)
				        WC()->cart->cart_contents[$key]['wapf_item_price'] = $pricing;
			    }
		    }
	    }

	    public function add_prices_to_cart_item($cart_obj) {
		    if (is_admin() && ! defined('DOING_AJAX'))
			    return;

		    foreach( $cart_obj->get_cart() as $key=>$item ) {
				if(isset($item['wapf_item_price']))
					$item['data']->set_price( floatval($item['wapf_item_price']['base']) + floatval( $item['wapf_item_price']['options_total'] ) );
		    }
        }


        public function display_fields_on_cart_and_checkout($item_data, $cart_item) {

            if(empty($cart_item['wapf']) || !is_array($cart_item['wapf']) )
                return $item_data;

            if (!is_array($item_data))
                $item_data = array();

            if(
	            (is_cart() && get_option('wapf_settings_show_in_cart','yes') === 'yes') || 
	            (is_checkout() && get_option('wapf_settings_show_in_checkout','yes') === 'yes') || 
	            (!is_checkout() && !is_cart() && get_option('wapf_settings_show_in_mini_cart','no') === 'yes' ) 
            ) {

	            foreach($cart_item['wapf'] as $field) {

                	if(!isset($field['values']))
                		continue;

                    if(Enumerable::from($field['values'])->any(function($x) use($cart_item){ return !empty($x['label']);})) {

	                    $item_data[] = array(
		                    'key'   => $field['label'],
		                    'value' => Enumerable::from( $field['values'] )->join( function ( $x ) use($cart_item, $field) {

			                    if ( $x['price_type'] !== 'none' && !empty($x['price']) ) {

				                    $v = isset($x['slug']) ? $x['label'] : $field['raw'];

				                    if(isset($cart_item['wapf_item_price']['options'][$field['id']][$v])) {

				                    	$pricing_hint = $cart_item['wapf_item_price']['options'][$field['id']][$v]['pricing_hint'];

					                    return sprintf(
						                    '%s %s',
						                    $x['label'],
						                    $pricing_hint
					                    );
				                    }

			                    }

			                    return $x['label'];
		                    }, ', ' )
	                    );
                    }

                }
            }

            return apply_filters('wapf/cart/item_data',$item_data, $cart_item);

        }

        public function mini_cart_display_product_price($price, $cart_item, $cart_item_key) {
		    if(!empty($cart_item['wapf_item_price']) && wp_doing_ajax() ) {
			    $price = floatval($cart_item['wapf_item_price']['base']) + floatval( $cart_item['wapf_item_price']['options_total'] );
			    $price = Helper::maybe_add_tax($cart_item['data'],$price,'cart');
			    $price = wc_price($price);
		    }
	        return $price;
        }

	    public function create_order_line_item($item, $cart_item_key, $values, $order) {

		    if (empty($values['wapf']))
			    return;

		    $meta = array();

		    foreach ($values['wapf'] as $field) {

			    if(Enumerable::from($field['values'])->any(function($x){ return !empty($x['label']);})) {

			    	$vals =  Enumerable::from( $field['values'] )->join( function ( $x ) use($item,$values,$field) {
					    if ( $x['price_type'] !== 'none' && !empty($x['price']) ) {

						    $v = isset($x['slug']) ? $x['label'] : $field['raw'];

						    if(isset($values['wapf_item_price']['options'][$field['id']][$v])) {

							    $pricing_hint = $values['wapf_item_price']['options'][$field['id']][$v]['pricing_hint'];

							    return sprintf(
								    '%s %s',
								    $x['label'],
								    $pricing_hint
							    );

						    }

					    }
					    return $x['label'];
				    }, ', ' );

				    $item->add_meta_data(
				    	$field['label'],
						$vals
				    );
				    $meta[] = array(
				        'id'    => $field['id'],
					    'label' => $field['label'],
					    'value' => $vals
				    );
			    }

		    }

		    $item->add_meta_data('_wapf_meta', $meta);

	    }

	    #region Private Helpers

        private function to_cart_fields(Field $field, $clone_idx = 0) {

            $raw_value = Fields::get_raw_field_value_from_request($field, $clone_idx);

            return array(
                'id'            => $field->id,
                'raw'           => $raw_value,
                'values'        => Fields::raw_to_cartfield_values($field, $raw_value,$clone_idx),
                'qty_based'     => $field->is_field_or_parent_qty_based(),
                'label'         => esc_html( $field->get_label() )
            );

        }

	    private function generate_cart_item_id($product_id, $variation_id, $data) {

		    return md5(json_encode(array(
			    (int) $product_id,
			    (int) $variation_id,
			    $data
		    )));

	    }

	    #endregion

    }
}