<?php

namespace SW_WAPF_PRO\Includes\Controllers {

    if (!defined('ABSPATH')) {
        die;
    }

    class Integrations_Controller
    {

        private $available_integrations = array(
	        'Barn2\Plugin\WC_Quick_View_Pro\Quick_View_Plugin'  => 'Quickview',
	        'WC_Product_Table_Plugin'                           => 'Product_Table',
	        'TierPricingTable\TierPricingTablePlugin'           => 'Tiered_Pricing_Table',
	       'WOOCS'                                              => 'Woocs'
        );

        private $available_themes = array(
        	'Woodmart' => 'Woodmart',
        	'Flatsome' => 'Flatsome'
        );

        public function __construct()
        {
        	add_action('plugins_loaded', array($this,'add_integrations'));
        }

        public function add_integrations() {
	        foreach ($this->available_integrations as $integration => $class) {
		        if(class_exists($integration)) {
		        	$n = 'SW_WAPF_PRO\\Includes\\Classes\\Integrations\\' . $class;
			        new $n();
		        }
	        }
	        foreach($this->available_themes as $theme_name => $class) {
	        	if(wp_get_theme()->Name === $theme_name) {
			        $n = 'SW_WAPF_PRO\\Includes\\Classes\\Integrations\\' . $class;
			        new $n();
		        }
	        }
        }


    }
}