<?php
namespace SW_WAPF_PRO\Includes\Classes\Integrations {

	use SW_WAPF_PRO\Includes\Classes\Cart;

	class Woocs
    {
        public function __construct() {
	        add_action('woocommerce_before_calculate_totals',   array($this, 'recalculate_pricing'),9);

	        add_filter('wapf/pricing/addon',                    array($this,'convert_addon_price'), 10, 4);

	        add_filter('wapf/pricing/product',                    array($this,'convert_product_price'), 10, 2);
        }

        public function convert_product_price($price, $product){

        	if(!$this->is_default_currency() && !$this->price_already_converted()) {
		        return $this->convert_to_current_currency($price);
	        }

	        return $price;
        }

        public function convert_addon_price($amount, $product, $type, $for_page){
	        if(!$this->is_default_currency() && !$this->product_has_fixed_price($product))
		      return (float) $this->convert_to_current_currency($amount);

	        return $amount;
        }

        public function recalculate_pricing($cart_obj) {

	        foreach( $cart_obj->get_cart() as $key=>$item ) {

		        if(!empty($item['wapf'])) {
			        $pricing = Cart::calculate_cart_item_options_total($item);
			        if($pricing !== false)
				        WC()->cart->cart_contents[$key]['wapf_item_price'] = $pricing;
		        }
	        }
        }

		private function price_already_converted() {
			if(get_option('woocs_is_multiple_allowed') != 1)
				return false;
			return true;
		}

		private function is_default_currency($curr = false) {
			global $WOOCS;
			if(!$curr)
				$curr = $WOOCS->current_currency;

			return strtolower($curr) === strtolower($WOOCS->default_currency);
		}

		private function product_has_fixed_price($product) {

			if(get_option('woocs_is_fixed_enabled') != 1)
				return false;

			global $WOOCS;

			$curr = $WOOCS->current_currency;

			$regular_price = get_post_meta( $product->get_id(), '_woocs_regular_price_' . $curr, true);
			if(!empty($regular_price) && floatval($regular_price) > 0)
				return true;

			$sale_price = get_post_meta( $product->get_id(), '_woocs_sale_price_' . $curr, true);
			if(!empty($sale_price) && floatval($sale_price) > 0 )
				return true;

			return false;
		}

		private function convert_to_current_currency($value) {
			return apply_filters('woocs_exchange_value', $value);
		}


    }
}