<?php

namespace SW_WAPF_PRO\Includes\Classes {

	class Cart {
		public static function calculate_cart_item_options_total($cart_item) {

			if(empty($cart_item['wapf']))
				return false;

			$quantity = isset($cart_item['quantity']) ? $cart_item['quantity'] : 1;
			$product_id = empty($cart_item['variation_id']) ? $cart_item['product_id'] : $cart_item['variation_id'];

			$product = wc_get_product($product_id);
			$base = Helper::get_product_base_price($product, $quantity);

			$data = array(
				'options_total' => 0,
				'base'          => $base,
				'options'       => array()
			);

			$options_total = 0;
			foreach ($cart_item['wapf'] as $field) {
				$prices = array();
				if(!empty($field['values'])) {
					foreach ($field['values'] as $value) {
						if($value['price'] === 0 || $value['price_type'] === 'none')
							continue;

						$v = isset($value['slug']) ? $value['label'] : $field['raw'];
						$price = Fields::do_pricing($field['qty_based'], $value['price_type'], $value['price'], $base, $quantity, $v, $product_id,$cart_item);
						$options_total = $options_total + $price;

						$prices[$v] = array(
							'price' => $price,
							'pricing_hint' => Helper::format_pricing_hint($value['price_type'],$price,$product,'cart'),
						);
					}
				}

				if(!empty($prices))
					$data['options'][$field['id']] = $prices;

			}

			$data['options_total'] = $options_total;
			$data['base'] = $base;

			return $data;

		}
	}
}