<?php

namespace SW_WAPF_PRO\Includes\Classes {

    class Cache
    {
        protected static $cache = array();
        protected static $clones = array();
        protected static $custom_css = array();
		protected static $files = array();

        public static function add_css($rule, array $css) {

        	if(isset(self::$custom_css[$rule]))
        		self::$custom_css[$rule] = array_merge(self::$custom_css[$rule],$css);

        	else self::$custom_css[$rule] = $css;
        }

        public static function has_css() {
        	return !empty(self::$custom_css);
        }

        public static function get_all_css() {
        	if(empty(self::$custom_css))
        		return '';

        	$css = '';

	        foreach(self::$custom_css as $rule => $styles) {
		        $css_str = Enumerable::from($styles)->join(function($v,$k){
			        return $k.':'.$v.';';
		        },'');
		        $css.= wp_strip_all_tags($rule . '{' . $css_str .'}');
	        }

	        return $css;
        }

        public static function add_clone($key,$data){
        	self::$clones[$key] = $data;
        }

        public static function get_clone($key) {
        	if(!isset(self::$clones[$key]))
        		return false;

        	return self::$clones[$key];
        }

        public static function set_files($files) {
        	self::$files = $files;
        }

        public static function get_files(){
        	return self::$files;
        }

        public static function set($key, $item) {
            self::$cache[$key] = $item;
        }

        public static function get($key) {

            if(!isset(self::$cache[$key]))
                return false;

            return self::$cache[$key];
        }

        public static function clear() {
            self::$cache = array();
        }

    }
}
