<?php
/** @var array $model */

use SW_WAPF_PRO\Includes\Classes\Html;
use SW_WAPF_PRO\Includes\Classes\Util;

if( ! empty( $model['data']['products'] ) ) {

    $qty_method = $model['field']->options['qty_method'];

    echo '<div class="wapf-radios"><input type="hidden" class="wapf-tf-h" data-fid="'.$model['field']->id.'" value="0" name="wapf[field_'.$model['field']->id.']" />';

    foreach ( $model['field']->options['choices'] as $i => $choice ) {

        if( ! isset( $model['data']['products'][ $choice['id'] ] ) ) {
            continue;
        }
        
        $the_product    = $model['data']['products'][ $choice['id'] ];
        $title          = $the_product->get_title();
        $price_type     = Util::get_product_price_type( $model['field'], $choice );

        // Prepare choice
        $choice['label']            = $title;
        $choice['pricing_type']     = $price_type;
        $choice['pricing_amount']   = $price_type === 'none' ? 0 : floatval( $the_product->get_price() );

        $class_atts = Html::get_option_classes_and_attributes( $model['field'], $model['product'], $choice, $model['default'], false, false, false, [ 'wapf-radio' ] );

        echo sprintf(
            '<div class="%s"><label class="wapf-input-label"><input type="radio" %s %s /><span class="wapf-custom"></span><span class="wapf-label-text">%s</span></label></div>',
            $class_atts['classes'],
            $class_atts['atts'],
            disabled(  ! $the_product->is_in_stock(), true, false ),
            esc_html( $title ) . ' ' . Html::product_pricing_hint( $the_product, $choice )
        );
        
        /*
         * echo sprintf(
            '<div class="%s"><label class="wapf-input-label"><input type="radio" %s /><span class="wapf-custom"></span><span class="wapf-label-text">%s</span></label></div>',
             $class_atts['classes'],
            $class_atts['atts'],
            esc_html( $option['label'] ) . ' ' . Html::frontend_option_pricing_hint( $option, $model['field'], $model['product'] )
        );
         */

    }

    echo '</div>';

}