<?php
/** @var array $model */

use SW_WAPF_PRO\Includes\Classes\Enumerable;
use SW_WAPF_PRO\Includes\Classes\Html;
use SW_WAPF_PRO\Includes\Classes\Util;

if( ! empty( $model['data']['products'] ) ) {
    $qty_method = $model['field']->options['qty_method'];
    
    echo '<select '. $model['field_attributes'] .'>';

    if( ! $model['field']->required || ($model['field']->required && ! Enumerable::from( $model['field']->options['choices'] )->any( function( $x ) {
                return isset($x['selected']) && $x['selected'] === true;
        })))
        echo '<option value="">' . esc_html( $model['data']['i18n_choose_option'] ) . '</option>';

    foreach ( $model['field']->options['choices'] as $i => $choice ) {

        if( ! isset( $model['data']['products'][ $choice['id'] ] ) ) {
            continue;
        }

        $the_product    = $model['data']['products'][ $choice['id'] ];
        $title          = $the_product->get_title();
        $price_type     = Util::get_product_price_type( $model['field'], $choice );

        // Prepare choice
        $choice['label']            = $title;
        $choice['pricing_type']     = $price_type;
        $choice['pricing_amount']   = $price_type === 'none' ? 0 : floatval( $the_product->get_price() );


    }
    
    echo '</select>';
?>

<select <?php echo $model['field_attributes']; ?>>
    <?php
    if(isset($model['field']->options['choices'])) {

        if(!$model['field']->required || ($model['field']->required && !Enumerable::from($model['field']->options['choices'])->any(function($x){
                    return isset($x['selected']) && $x['selected'] === true;
                })))
            echo '<option value="">' . esc_html( $model['data']['i18n_choose_option'] ) . '</option>';

        foreach($model['field']->options['choices'] as $option) {

            $attributes = Html::select_option_attributes( $option, $model['field'], $model['product'], $model['is_edit'], $model['default']);

            echo sprintf(
                '<option %s>%s</option>',
                Enumerable::from($attributes)->join(function($value,$key) {
                    if($value)
                        return $key . '="' . esc_attr($value) .'"';
                    else return $key;
                },' '),
                esc_html($option['label']) .  ' ' . Html::frontend_option_pricing_hint( $option, $model['field'], $model['product'] )
            );
        }
    }
    ?>
</select>
<?php } ?>