<?php
/** @var array $model */

use SW_WAPF_PRO\Includes\Classes\Html;
use SW_WAPF_PRO\Includes\Classes\Util;

if( ! empty( $model['data']['products'] ) ) {

    $qty_method = $model['field']->options['qty_method'];

    echo '<div class="wapf-checkboxes"><input type="hidden" class="wapf-tf-h" data-fid="'.$model['field']->id.'" value="0" name="wapf[field_'.$model['field']->id.'][]" />';

    foreach ( $model['field']->options['choices'] as $i => $choice ) {

        if( ! isset( $model['data']['products'][ $choice['id'] ] ) ) {
            continue;
        }

        $default        = is_array( $model['default'] ) && isset( $model['default'][ $i ] ) ?  $model['default'][ $i ] : ( $choice['selected'] ? 1 : 0 );

        $the_product    = $model['data']['products'][ $choice['id'] ];
        $title          = $the_product->get_title();
        $price_type     = Util::get_product_price_type(  $model['field'], $choice);
        $selected       = $default > 0;
        
        // Prepare choice
        $choice['label']            = $title;
        $choice['pricing_type']     = $price_type;
        $choice['pricing_amount']   = $price_type === 'none' ? 0 : floatval( $the_product->get_price() );
        
        $class_atts = Html::get_option_classes_and_attributes( $model['field'], $model['product'], $choice, $model['default'], $qty_method !== 'custom', false, $qty_method === 'custom', [ 'wapf-checkbox' ] );
        
        if( $qty_method === 'custom' ) {
            echo sprintf(
                '<div class="wapf-custom-qty %s">
                    <div>
                        <input aria-labelledby="%s" type="checkbox" %s %s /><span class="wapf-custom"></span>
                    </div>
                    <div>
                        <input data-no-zero="1" type="number" min="0" step="1" value="' . esc_attr( $default ) . '" %s />
                    </div>
                    <div>
                        <label for="%s" class="wapf-input-label"><span class="wapf-label-text">%s</span></label>
                    </div>
                </div>',
                $class_atts['classes'],
                $class_atts['id'],
                disabled(  ! $the_product->is_in_stock(), true, false ),
                checked( $selected, true, false ), 
                $class_atts['atts'],
                $class_atts['id'],
                esc_html( $title ) . ' ' . Html::product_pricing_hint( $the_product, $choice )
            );
        } else {
            echo sprintf(
        '<div class="%s">
                    <input type="checkbox" %s %s /><span class="wapf-custom"></span>
                    <label for="%s" class="wapf-input-label"><span class="wapf-label-text">%s</span></label>
                </div>',
                $class_atts['classes'],
                $class_atts['atts'],
                disabled(  ! $the_product->is_in_stock(), true, false ),
                $class_atts['id'],
                esc_html( $title ) . ' ' . Html::product_pricing_hint( $the_product, $choice )
            );
        }

    }

    echo '</div>';

}