<?php
/** @var array $model */

use SW_WAPF_PRO\Includes\Classes\Enumerable;
use SW_WAPF_PRO\Includes\Classes\Html;

$cols = isset($model['field']->options['items_per_row']) ? intval($model['field']->options['items_per_row']) : 3;
$cols_tablet = isset($model['field']->options['items_per_row_tablet']) ? intval($model['field']->options['items_per_row_tablet']) : 3;
$cols_mobile = isset($model['field']->options['items_per_row_mobile']) ? intval($model['field']->options['items_per_row_mobile']) : 3;

if(!empty($model['field']->options['choices'])) {

	echo '<div class="wapf-image-swatch-wrapper wapf-swatch-wrapper wapf-col--'.$cols.'" style="--wapf-cols:'.$cols.';--wapf-cols-t:'.$cols_tablet.';--wapf-cols-m:'.$cols_mobile.'">';
    echo '<input type="hidden" class="wapf-tf-h" data-fid="' . $model['field']->id . '" value="0" name="wapf[field_' . $model['field']->id . ']" />';
    
	foreach ($model['field']->options['choices'] as $option) {

        $class_atts = Html::get_option_classes_and_attributes( $model['field'], $model['product'], $option, $model['default'], false, true, false, [] );
        $wrapper_attributes = Html::image_swatch_wrapper_attributes( $option, $model['field'] );

		echo sprintf(
			'<div class="wapf-swatch wapf-swatch--image wapf-single-select %s" %s><label aria-label="%s"><input type="radio" %s />%s%s</label></div>',
			$class_atts['classes'],
            Enumerable::from($wrapper_attributes)->join(function($value,$key) { return $key . '="' . esc_attr($value) .'"'; }, ' '),
            esc_attr( $option['label'] ?? '' ),
            $class_atts['atts'],
			Html::get_swatch_image_html( $model['field'], $model['product'], $option ),
			Html::swatch_label($model['field'], $option, $model['product'])
		);
        
	}

	echo '</div>';

}