<?php /* @var $model array */ ?>

<div style="width: 100%;padding-bottom:10px" rv-show="field.choices | isNotEmpty">
    <div class="wapf-options__header">
        <div class="wapf-option__sort"></div>
        <div class="wapf-option__flex"><?php _e('Product','sw-wapf'); ?></div>
        <div class="wapf-option__flex"><?php _e('Price','sw-wapf'); ?></div>
        <?php if( ! empty($model['has_quantities'] ) ) { ?>
            <div class="wapf-option"><?php _e('More', 'sw-wapf') ?></div>
        <?php } else { ?>
        <div class="wapf-option__selected"><?php _e('Selected', 'sw-wapf'); ?></div>
        <?php } ?>
        <div  class="wapf-option__delete"></div>
    </div>
    <div rv-sortable-options="field.choices" class="wapf-options__body">
        <div class="wapf-option" rv-each-choice="field.choices" rv-data-option-slug="choice.slug">
            <div class="wapf-option__sort"><span rv-sortable-option class="wapf-option-sort">☰</span></div>
            <div class="wapf-option__flex">
               <select
                    data-select2-keys="id,label"
                    rv-on-change="onChange"
                    rv-select2="choice"
                    multiple="multiple"
                    class="wapf-select2"
                    data-select2-placeholder="<?php __("Search a product...",'sw-wapf') ?>"
                    data-select2-action="wapf_product_picker"
                    data-select2-single="true"
                >
                </select>
            </div>
            <div class="wapf-option">
                <select rv-value="choice.pricing_type">
                    <option value="none"><?php _e( 'Free', 'sw-wapf') ?></option>
                    <option value="fixed"><?php _e( 'Product price', 'sw-wapf') ?></option>
                </select>
            </div>
            <?php if( ! empty($model['has_quantities'] ) ) { ?>
                <div class="wapf-option" style="">
                    <a rv-data-modal="$index | prepend 'wapf-product-search-settings'" href="#" style="display: block;padding:7px 0px 5px 7px;" >
                        <?php _e('More settings', 'sw-wapf') ?>
                    </a>
                    <div rv-class="$index | prepend 'wapf_modal_overlay wapf-product-search-settings'">
                        <div class="wapf_modal">
                            <a class="wapf_close" href="#" onclick="javascript:event.preventDefault();jQuery('.wapf-product-search-settings').hide();">&times;</a>
                            <h3><?php _e('More settings','sw-wapf') ?></h3>
                            <div style="line-height: 1.5;padding-top:15px">
                                <div class="wapf-field-body">
                                    <div class="wapf-field__setting">
                                        <div class="wapf-setting__label" style="width: 40%">
                                            <label><?php _e( 'Default value', 'sw-wapf' ) ?></label>
                                        </div>
                                        <div class="wapf-setting__input">
                                            <?php echo \SW_WAPF_PRO\Includes\Classes\Html::admin_choice_option_extra_input([
                                                    'type'          => 'number',
                                                    'key'           => 'default',
                                                    'default'       => 0,
                                                    'attrs'         => [ 'min' => 0 ]
                                            ]); ?>
                                        </div>
                                    </div>
                                    <div class="wapf-field__setting">
                                        <div class="wapf-setting__label" style="width: 40%">
                                            <label><?php _e( 'Min.', 'sw-wapf' ) ?></label>
                                        </div>
                                        <div class="wapf-setting__input">
                                            <?php echo \SW_WAPF_PRO\Includes\Classes\Html::admin_choice_option_extra_input(
                                                [
                                                    'type'          => 'number',
                                                    'key'           => 'min',
                                                    'attrs'         => [ 'min' => 0 ]
                                                ]
                                            ); ?>
                                        </div>
                                    </div>
                                    <div class="wapf-field__setting">
                                        <div class="wapf-setting__label" style="width: 40%">
                                            <label><?php _e( 'Max.', 'sw-wapf' ) ?></label>
                                        </div>
                                        <div class="wapf-setting__input">
                                        <?php echo \SW_WAPF_PRO\Includes\Classes\Html::admin_choice_option_extra_input(
                                            [
                                                'type'          => 'number',
                                                'key'           => 'max'
                                            ]
                                        ); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } else { ?>
            <div class="wapf-option__selected">
                <div class="wapf-option__selected"><input data-multi-option="<?php echo !empty( $model['multi_option'] ) ? '1' : '0' ;?>" rv-on-change="field.checkSelected" rv-checked="choice.selected" type="checkbox" /></div>
            </div>
            <?php } ?>
            <div class="wapf-option__delete">
                <a href="#" rv-on-click="field.deleteChoice" class="button wapf-button--tiny-rounded">&times;</a>
            </div>
        </div>
    </div>
</div>

<div>
    <a href="#" rv-on-click="field.addChoiceEvent" class="button"><?php _e('Add product','sw-wapf'); ?></a>
</div>
